package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.DocumentReviewNote;
import gov.va.vinci.dart.biz.RequestLocationDocument;
import gov.va.vinci.dart.biz.RequestParticipantDocument;
import gov.va.vinci.dart.db.DocumentReviewNoteDAO;
import gov.va.vinci.dart.dms.biz.Document;

public class DocumentReviewNoteDAOMock implements DocumentReviewNoteDAO {

	private static final HashMap<Integer,DocumentReviewNote> IDHash = new HashMap<Integer,DocumentReviewNote>();
	private static boolean initialized = false;
	private static int idCounter = 1;

	@Override
	public void save(DocumentReviewNote note) {
		if (note == null) {
			throw new IllegalArgumentException();
		}

		initializeNoteHash();

		if (note.getId() == 0) {
			note.setId(idCounter++);
		}
		
		IDHash.put(note.getId(), note);
	}

	@Override
	public DocumentReviewNote findById(int documentId, String createdBy) {
		
		initializeNoteHash();
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);
			if (note.getDocument().getId() == documentId && note.getCreatedBy().equals(createdBy)) {
				return note;
			}
		}

		return null;
	}

	@Override
	public List<DocumentReviewNote> listByReviewerId(String createdBy,
			int documentId, int groupId) {
		initializeNoteHash();

		List<DocumentReviewNote> result = new ArrayList<DocumentReviewNote>();
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);
			if (note.getDocument().getId() == documentId 
					&& note.getCreatedBy().equals(createdBy)
					&& note.getGroup().getId() == groupId) {
				result.add(note);
			}
		}
		
		return result;
	}
	
	@Override
	public List<DocumentReviewNote> listByGroupId(int documentId, int groupId) {
		initializeNoteHash();

		List<DocumentReviewNote> result = new ArrayList<DocumentReviewNote>();
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);
			if (note.getDocument().getId() == documentId 
					&& note.getGroup().getId() == groupId) {
				result.add(note);
			}
		}
		
		return result;
	}	

	@Override
	public List<DocumentReviewNote> listByGroupIdForDocumentVersions(final int documentHeadId, final int groupId) {
		initializeNoteHash();

		List<DocumentReviewNote> result = new ArrayList<DocumentReviewNote>();
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);
			if( (note.getDocument().getId() == documentHeadId || note.getDocument().getHead() == documentHeadId)
				&& note.getGroup().getId() == groupId ) {
				result.add(note);
			}
		}
		
		return result;
	}
	
//	@Override
//	public List<DocumentReviewNote> listByGroupIdForRequestAndDocumentContent(final int requestId, final int documentId, final int contentId, final int groupId) {
//		initializeNoteHash();
//
//		List<DocumentReviewNote> result = new ArrayList<DocumentReviewNote>();
//
//		for (Integer id: IDHash.keySet()) {
//			DocumentReviewNote note = IDHash.get(id);
//			
//			if( note.getDocument() != null && note.getDocument().getRequest() != null && note.getGroup() != null ) {
//				
//				if( note.getDocument().getRequest().getId() == requestId && 
//					note.getGroup().getId() == groupId &&
//					(note.getDocument().getId() == documentId || note.getDocument().getHead() == documentId) || (note.getDocument().getContent() != null && note.getDocument().getContent().getId() == contentId) ) {
//					result.add(note);
//				}//end if
//				
//			}//end if
//		}//end for
//		
//		return result;
//	}
	
	
	@Override
	public Integer countNotesForActiveLocationDocsAndGroupId(final int requestHeadId, final int locationId, final int groupId) {
		initializeNoteHash();

		int ct = 0;
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);

			if( note.getGroup().getId() == groupId ) {	//note written by this group
				
				Document doc = note.getDocument();
				if( doc.getRequest().getId() == requestHeadId || doc.getRequest().getHeadId() == requestHeadId ) {	//request chain
					
					List<RequestLocationDocument> rldList = RequestLocationDocument.listByRequestAndLocationId(doc.getRequest().getId(), locationId);
					if( rldList != null ) {
						for( RequestLocationDocument rld : rldList ) {
							if( rld != null && rld.isActive() && rld.getDocumentId() == doc.getId() ) {	//have an active RequestLocationDocument for this location, request, and document
								ct++;
							}
						}
					}
				}
			}
		}
		
		return ct;
	}
	
	@Override
	public Integer countNotesForActiveParticipantDocsAndGroupId(final int requestHeadId, final int participantId, final int groupId) {
		initializeNoteHash();

		int ct = 0;
		
		for (Integer id: IDHash.keySet()) {
			DocumentReviewNote note = IDHash.get(id);

			if( note.getGroup().getId() == groupId ) {	//note written by this group
				
				Document doc = note.getDocument();
				if( doc.getRequest().getId() == requestHeadId || doc.getRequest().getHeadId() == requestHeadId ) {	//request chain
					
					List<RequestParticipantDocument> rpdList = RequestParticipantDocument.listByRequestAndParticipantId(doc.getRequest().getId(), participantId);
					if( rpdList != null ) {
						for( RequestParticipantDocument rpd : rpdList ) {
							if( rpd != null && rpd.isActive() && rpd.getDocumentId() == doc.getId() ) {	//have an active RequestLocationDocument for this location, request, and document
								ct++;
							}
						}
					}
				}
			}
		}
		
		return ct;
	}
	
	
	private void initializeNoteHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}
	
    @Override
    public int countDocumentVersions(final int documentHeadId, final int groupId) {
        /*Query q = createNativeQuery("SELECT count(*) FROM [hib].[documentreviewnote] note, [hib].[group] grp where note.documentid=:did and grp.id=:gid");
        q.setParameter("did", documentHeadId);
		q.setParameter("gid", groupId);
        int iVal = (Integer) q.getSingleResult();*/
    	int iVal = 1;

        return iVal;
    }

}
